﻿using System;
using System.Runtime.Serialization;
using VIRP.ViaService;
using AntiXssEnc = Microsoft.Security.Application;

namespace VIRP.CRS.BO
{
    [Serializable, DataContract]
    public partial class ViaPerson
    {
        #region Fields
        private string faultField;
        private string patientNameField;
        private string patientDobField;
        private string patientGenderField;
        private string patientSnumField;
        private string mpiPidField;
        private string localPidField;
        private string admitTimestampField;
        private string locationIdField;
        private string locationFacilityNameField;
        private string userDuzField;
        private string userNameField;
        private string userSiteIdField;
        #endregion

        #region Constructors
        public ViaPerson()
        {
        }

        public ViaPerson(personsTO persons)
        {
            if (persons != null)
            {
                if (persons.fault != null)
                    this.faultField = AntiXssEnc.Encoder.HtmlEncode(persons.fault.message);

                if (persons.patient != null)
                {
                    this.patientNameField = AntiXssEnc.Encoder.HtmlEncode(persons.patient.patientName);
                    this.patientDobField = AntiXssEnc.Encoder.HtmlEncode(persons.patient.dob);
                    this.patientGenderField = AntiXssEnc.Encoder.HtmlEncode(persons.patient.gender);
                    this.patientSnumField = AntiXssEnc.Encoder.HtmlEncode(persons.patient.snum);
                    this.mpiPidField = AntiXssEnc.Encoder.HtmlEncode(persons.patient.mpiPid);
                    this.localPidField = AntiXssEnc.Encoder.HtmlEncode(persons.patient.localPid);
                    this.admitTimestampField = AntiXssEnc.Encoder.HtmlEncode(persons.patient.admitTimestamp);

                    if (persons.patient.location != null)
                    {
                        this.locationIdField = AntiXssEnc.Encoder.HtmlEncode(persons.patient.location.id);

                        if (persons.patient.location.facility != null)
                            this.locationFacilityNameField = AntiXssEnc.Encoder.HtmlEncode(persons.patient.location.facility.name);
                    }
                }

                if (persons.user != null)
                {
                    this.userSiteIdField = AntiXssEnc.Encoder.HtmlEncode(persons.user.siteId);
                    this.userNameField = AntiXssEnc.Encoder.HtmlEncode(persons.user.name);
                    this.userDuzField = AntiXssEnc.Encoder.HtmlEncode(persons.user.DUZ);
                }
            }
        }
        #endregion

        #region Properties
        public string Fault
        {
            get { return this.faultField; }
            set { this.faultField = value; }
        }

        public string PatientName
        {
            get { return this.patientNameField; }
            set { this.patientNameField = value; }
        }

        public string PatientDob
        {
            get { return this.patientDobField; }
            set { this.patientDobField = value; }
        }

        public string PatientGender
        {
            get { return this.patientGenderField; }
            set { this.patientGenderField = value; }
        }

        public string PatientSnum
        {
            get { return this.patientSnumField; }
            set { this.patientSnumField = value; }
        }

        public string MpiPid
        {
            get { return this.mpiPidField; }
            set { this.mpiPidField = value; }
        }

        public string LocalPid
        {
            get { return this.localPidField; }
            set { this.localPidField = value; }
        }

        public string AdmitTimestamp
        {
            get { return this.admitTimestampField; }
            set { this.admitTimestampField = value; }
        }

        public string LocationId
        {
            get { return this.locationIdField; }
            set { this.locationIdField = value; }
        }

        public string LocationFacilityName
        {
            get { return this.locationFacilityNameField; }
            set { this.locationFacilityNameField = value; }
        }

        public string UserDuz
        {
            get { return this.userDuzField; }
            set { this.userDuzField = value; }
        }

        public string UserName
        {
            get { return this.userNameField; }
            set { this.userNameField = value; }
        }

        public string UserSiteId
        {
            get { return this.userSiteIdField; }
            set { this.userSiteIdField = value; }
        }

        #endregion

        #region Methods
        #endregion
    }
}
